
  /*
   *  Object %name    : parser_atp_kmng_activatekeys.c%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the KMNG parsing functions  
   *
   *  \version parser.c#1:csrc:1
   *  \author Annag
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include <stdio.h>
#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "kmngatptest_msg_defs.h"
#include "CRYS_SEP_ATP_Defines.h"
#include "DX_VOS_Mem.h"
#include "KMNG_SEP_ATP_RSA_PRIME_ActivateKeys.h"
#include "KMNG_SEP_ATP_RSA_V15_ActivateKeys.h"
#include "KMNG_SEP_ATP_RSA_V21_ActivateKeys.h"
#include "KMNG_SEP_ATP_ActivateSymKeys.h"
#include "SEP_ATP_UTIL_funcs.h"
#include "KMNG_SEP_ATP_TestDataDefines.h"


/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/
extern TST_Ext_KeysSym_TestDataStruct *SEP_KeysOpSym_TestData;
extern TST_Ext_KeysRSA_TestDataStruct *SEP_KeysOpRSA_TestData;

/**************** Private function prototypes ****************/

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_KMNG_AESActivateKeys

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* KMNG import export symmetric keys test.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. Allocate memory buffers
* 2. extract parameters from the message 
* 3. call QA SEP functions
* 4. Free allocated buffers
* 5. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_KMNG_AES_ActivateKeys(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;
	
	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;
	

	/* 1. Allocate memory buffers */
	/******************************/
	SEP_KeysOpSym_TestData = DX_VOS_MemMalloc(sizeof(TST_Ext_KeysSym_TestDataStruct));

	if (SEP_KeysOpSym_TestData == DX_NULL)
	{
		SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_Ext_KeysSym_TestDataStruct ");
		goto End;                                                                       
	}

	/* 2. extract parameters from the message */
	/******************************************/
	DX_VOS_FastMemCpy(&SEP_KeysOpSym_TestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_Ext_KeysSym_TestDataStruct));


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = sizeof(TST_Ext_KeysSym_TestDataStruct)/4 + DX_SEP_HOST_SEP_BASE_MSG_OFFSET;
		
	/* 3. call QA SEP functions */
	/***************************/
	SEP_Error = SEP_KMNG_ATP_Ext_AESActivateOperation();
	SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEP_KMNG_ATP_Ext_AESActivateOperation");
	
End:
	/* 4. Free allocated buffers */
	DX_VOS_MemFree(SEP_KeysOpSym_TestData);

	/* 5. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_KMNG_DESActivateKeys

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* KMNG activate DES key test.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. Allocate memory buffers
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. Free allocated buffers
* 5. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_KMNG_DES_ActivateKeys(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;

	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;


	/* 1. Allocate memory buffers */
	/******************************/
	SEP_KeysOpSym_TestData = DX_VOS_MemMalloc(sizeof(TST_Ext_KeysSym_TestDataStruct));

	if (SEP_KeysOpSym_TestData == DX_NULL)
	{
		SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_Ext_KeysSym_TestDataStruct ");
		goto End;                                                                       
	}

	/* 2. extract parameters from the message */
	/******************************************/
	DX_VOS_FastMemCpy(&SEP_KeysOpSym_TestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_Ext_KeysSym_TestDataStruct));


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = sizeof(TST_Ext_KeysSym_TestDataStruct)/4 + DX_SEP_HOST_SEP_BASE_MSG_OFFSET;

	/* 3. call QA SEP function */
	/***************************/
	SEP_Error = SEP_KMNG_ATP_Ext_DESActivateOperation();

	SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEP_KMNG_ATP_Ext_DESActivateOperation");


End:
	/* 4. Free allocated buffers */
	DX_VOS_MemFree(SEP_KeysOpSym_TestData);

	/* 5. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_KMNG_HMACActivateKeys

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* KMNG activate HMAC key test.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. Allocate memory buffers
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. Free allocated buffers
* 5. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_KMNG_HMAC_ActivateKeys(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;

	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;


	/* 1. Allocate memory buffers */
	/******************************/
	SEP_KeysOpSym_TestData = DX_VOS_MemMalloc(sizeof(TST_Ext_KeysSym_TestDataStruct));

	if (SEP_KeysOpSym_TestData == DX_NULL)
	{
		SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_Ext_KeysSym_TestDataStruct ");
		goto End;                                                                       
	}

	/* 2. extract parameters from the message */
	/******************************************/
	DX_VOS_FastMemCpy(&SEP_KeysOpSym_TestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_Ext_KeysSym_TestDataStruct));


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = sizeof(TST_Ext_KeysSym_TestDataStruct)/4 + DX_SEP_HOST_SEP_BASE_MSG_OFFSET;

	/* 3. call QA SEP function */
	/***************************/
	SEP_Error = SEP_KMNG_ATP_Ext_HMACActivateOperation();

	SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEP_KMNG_ATP_Ext_HMACActivateOperation");


End:
	/* 4. Free allocated buffers */
	DX_VOS_MemFree(SEP_KeysOpSym_TestData);

	/* 5. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_KMNG_RSA_V15_ActivateKeys

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* KMNG activate RSA key and RSA prime and v15 encrypt, decrypt, sign, verify operations test.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. Allocate memory buffers
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. Free allocated buffers
* 5. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_KMNG_RSA_V15_ActivateKeys(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;

	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;


	/* 1. Allocate memory buffers */
	/******************************/
	SEP_KeysOpRSA_TestData = DX_VOS_MemMalloc(sizeof(TST_Ext_KeysRSA_TestDataStruct));

	if (SEP_KeysOpRSA_TestData == DX_NULL)
	{
		SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_Ext_KeysRSA_TestDataStruct ");
		goto End;                                                                       
	}

	/* 2. extract parameters from the message */
	/******************************************/
	DX_VOS_FastMemCpy(&SEP_KeysOpRSA_TestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_Ext_KeysRSA_TestDataStruct));


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengths                     */
	SEP_MsgLengthInWords = sizeof(TST_Ext_KeysRSA_TestDataStruct)/4 + DX_SEP_HOST_SEP_BASE_MSG_OFFSET;

	/* 3. call QA SEP functions */
	/***************************/
	SEP_Error = SEP_KMNG_ATP_Ext_RSA_V15_ActivateOperation();
	SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEP_KMNG_ATP_Ext_RSA_V15_ActivateOperation");

End:
	/* 4. Free allocated buffers */
	DX_VOS_MemFree(SEP_KeysOpRSA_TestData);

	/* 5. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_KMNG_RSA_PRIME_ActivateKeys

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* KMNG activate RSA key and RSA prime encrypt, decrypt operations test.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. Allocate memory buffers 
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. Free allocated buffers
* 5. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_KMNG_RSA_PRIME_ActivateKeys(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;

	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;


	/* 1. Allocate memory buffers */
	/******************************/
	SEP_KeysOpRSA_TestData = DX_VOS_MemMalloc(sizeof(TST_Ext_KeysRSA_TestDataStruct));

	if (SEP_KeysOpRSA_TestData == DX_NULL)
	{
		SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_Ext_KeysRSA_TestDataStruct ");
		goto End;                                                                       
	}

	/* 2. extract parameters from the message */
	/******************************************/
	DX_VOS_FastMemCpy(&SEP_KeysOpRSA_TestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_Ext_KeysRSA_TestDataStruct));


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengths                     */
	SEP_MsgLengthInWords = sizeof(TST_Ext_KeysRSA_TestDataStruct)/4 + DX_SEP_HOST_SEP_BASE_MSG_OFFSET;

	/* 3. call QA SEP function */
	/***************************/
	SEP_Error = SEP_KMNG_ATP_Ext_RSA_PRIME_ActivateOperation();

	SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEP_KMNG_ATP_Ext_RSA_PRIME_ActivateOperation");

End:
	/* 4. Free allocated buffers */
	DX_VOS_MemFree(SEP_KeysOpRSA_TestData);

	/* 5. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_KMNG_RSA_V21_ActivateKeys

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* KMNG activate RSA key and RSA v21 encrypt, decrypt, sign, verify operations test.
* It calls the SEP function with parameters parsed from input message
* Algorithm:
* 1. Allocate memory buffers
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. Free allocated buffers
* 5. End SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_KMNG_RSA_V21_ActivateKeys(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;

	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;


	/* 1. Allocate memory buffers */
	/******************************/
	SEP_KeysOpRSA_TestData = DX_VOS_MemMalloc(sizeof(TST_Ext_KeysRSA_TestDataStruct));

	if (SEP_KeysOpRSA_TestData == DX_NULL)
	{
		SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_Ext_KeysRSA_TestDataStruct ");
		goto End;                                                                       
	}

	/* 2. extract parameters from the message */
	/******************************************/
	DX_VOS_FastMemCpy(&SEP_KeysOpRSA_TestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_Ext_KeysRSA_TestDataStruct));


	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengths                     */
	SEP_MsgLengthInWords = sizeof(TST_Ext_KeysRSA_TestDataStruct)/4 + DX_SEP_HOST_SEP_BASE_MSG_OFFSET;

	/* 3. call QA SEP functions */
	/***************************/
	SEP_Error = SEP_KMNG_ATP_Ext_RSA_V21_ActivateOperation();
	SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEP_KMNG_ATP_Ext_RSA_V21_ActivateOperation");

End:
	/* 4. Free allocated buffers */
	DX_VOS_MemFree(SEP_KeysOpRSA_TestData);
	

	/* 5. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}






